using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Diagnostics;
using System.Globalization;
using Zcu.Mve.Numerics;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Setup for VectorSource property setting .
	/// </summary>
	public class VectorSourceSetup : Zcu.Mve.Core.ModuleSetup
	{
		private System.Windows.Forms.TextBox textBox1;
		private System.Windows.Forms.Label label1;
		private System.ComponentModel.IContainer components = null;
		private VectorSource vectSrc;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.RadioButton radioButton1;
		private System.Windows.Forms.RadioButton radioButton2;
		private System.Windows.Forms.RadioButton radioButton3;
		private NumberFormatInfo nfi = new CultureInfo("en-US", false).NumberFormat;

		/// <summary>
		/// Create the setting dialog.
		/// </summary>
		/// <param name="vectSrc"></param>
		public VectorSourceSetup(VectorSource vectSrc)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();


			this.vectSrc = vectSrc;
			this.textBox1.Text = "";

			if (vectSrc == null || vectSrc.Vect == null)
			{
				this.textBox1.Text += "0";        
			}
			else
			{
				VectorND tmp = new VectorND(0);
				switch (vectSrc.Vect.GetType().Name)
				{
					case "Vector2D":
						tmp = (VectorND)((Vector2D)vectSrc.Vect);
						radioButton1.Checked = true;
						break;
					case "Vector3D":
						tmp = (VectorND)((Vector3D)vectSrc.Vect);
						radioButton2.Checked = true;
						break;
					case "VectorND":
						tmp = (VectorND) vectSrc.Vect;
						radioButton3.Checked = true;
						break;
				}
				foreach (double val in tmp.Values)
				{
					this.textBox1.Text += val.ToString(nfi) + " ";
				}
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.radioButton3 = new System.Windows.Forms.RadioButton();
			this.radioButton2 = new System.Windows.Forms.RadioButton();
			this.radioButton1 = new System.Windows.Forms.RadioButton();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(8, 50);
			this.textBox1.Name = "textBox1";
			this.textBox1.Size = new System.Drawing.Size(192, 20);
			this.textBox1.TabIndex = 0;
			this.textBox1.Text = "0 0 0";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 10);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(192, 32);
			this.label1.TabIndex = 1;
			this.label1.Text = "Insert vector values. \r\nFor example: 5.2 4 -2";
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.radioButton3);
			this.groupBox1.Controls.Add(this.radioButton2);
			this.groupBox1.Controls.Add(this.radioButton1);
			this.groupBox1.Location = new System.Drawing.Point(8, 80);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(192, 96);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Output type";
			// 
			// radioButton3
			// 
			this.radioButton3.Checked = true;
			this.radioButton3.Location = new System.Drawing.Point(44, 64);
			this.radioButton3.Name = "radioButton3";
			this.radioButton3.TabIndex = 0;
			this.radioButton3.TabStop = true;
			this.radioButton3.Text = "VectorND";
			// 
			// radioButton2
			// 
			this.radioButton2.Location = new System.Drawing.Point(44, 40);
			this.radioButton2.Name = "radioButton2";
			this.radioButton2.TabIndex = 1;
			this.radioButton2.Text = "Vector3D";
			// 
			// radioButton1
			// 
			this.radioButton1.Location = new System.Drawing.Point(44, 16);
			this.radioButton1.Name = "radioButton1";
			this.radioButton1.TabIndex = 0;
			this.radioButton1.Text = "Vector2D";
			// 
			// VectorSourceSetup
			// 
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.textBox1);
			this.Name = "VectorSourceSetup";
			this.Size = new System.Drawing.Size(208, 184);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
	
		/// <summary>
		/// Button OK click.
		/// </summary>
		/// <returns></returns>
		public override bool OnOkClick()
		{
			string [] vals = this.textBox1.Text.Trim().Split(' ');
			// mv - 2004-08-16 - pristupove pravo u Values zmeneno z public na private
			//      vectSrc.Vect.Values = new double [vals.Length];
			VectorND vect = new VectorND(new double [vals.Length]);
      
			try 
			{
				int i = 0;
				foreach (string str in vals)
				{
					vect[i] = Double.Parse(str, nfi);
					i++;
				}
			}
			catch (FormatException ex)
			{
				Debug.WriteLine(ex.Message);
				// zavraneni ukonceni dialogu
				throw new Zcu.Mve.Core.MveException("Incorrect number format in VectorSource Setup.");
			}

			if (radioButton1.Checked)
				vectSrc.Vect = (Vector2D) vect;

			if (radioButton2.Checked)
				vectSrc.Vect = (Vector3D) vect;
      
			if (radioButton3.Checked)
				vectSrc.Vect = vect;
      
			vectSrc.Execute();
			return true;
		}
	}
}

