using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Dialog box for VectorRenderer settings.
	/// </summary>
	public class VectorRendererSettings : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.CheckBox checkBox1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.CheckBox checkBox2;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.CheckBox checkBox4;
		private System.Windows.Forms.CheckBox checkBox3;
		private System.Windows.Forms.NumericUpDown numericUpDown1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.CheckBox checkBox5;
		private System.Windows.Forms.NumericUpDown numericUpDown2;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.NumericUpDown numericUpDown3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.NumericUpDown numericUpDown4;
		private System.Windows.Forms.ColorDialog colorDialog1;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.Button button4;
		private System.Windows.Forms.ColorDialog colorDialog2;
		private System.Windows.Forms.GroupBox groupBox4;
		private VectorRendererPanel rendererPanel;

		/// <summary>
		/// Create dialog box.
		/// </summary>
		/// <param name="rendererPanel">VectorRenderer panel.</param>
		public VectorRendererSettings(VectorRendererPanel rendererPanel)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			this.rendererPanel = rendererPanel;
			this.checkBox1.Checked = this.rendererPanel.showXGrid;
			this.checkBox2.Checked = this.rendererPanel.showYGrid;
			this.checkBox3.Checked = this.rendererPanel.showXAxesLegend;
			this.checkBox4.Checked = this.rendererPanel.showYAxesLegend;
			this.numericUpDown1.Value = this.rendererPanel.y_segment_count;
			this.checkBox5.Checked = this.rendererPanel.showGraphMarks;
			this.numericUpDown2.Enabled = this.checkBox5.Checked;
			this.numericUpDown4.Enabled = this.checkBox5.Checked;
			this.label2.Enabled = this.checkBox5.Checked;
			this.label4.Enabled = this.checkBox5.Checked;
			this.label6.Enabled = this.checkBox5.Checked;
			this.button4.Enabled = this.checkBox5.Checked;
			this.numericUpDown2.Value = (int) this.rendererPanel.graph_mark_size;
			this.numericUpDown4.Value = this.rendererPanel.graphMarkLineWidth;
			this.numericUpDown3.Value = this.rendererPanel.graphLineWidth;
			this.colorDialog1.Color = this.rendererPanel.graphLineColor;
			this.button3.BackColor = this.colorDialog1.Color;
			this.colorDialog2.Color = this.rendererPanel.marksLineColor;
			this.button4.BackColor = this.colorDialog2.Color;
		} // VectorRendererSettings()

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.checkBox1 = new System.Windows.Forms.CheckBox();
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.checkBox2 = new System.Windows.Forms.CheckBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.checkBox4 = new System.Windows.Forms.CheckBox();
			this.checkBox3 = new System.Windows.Forms.CheckBox();
			this.numericUpDown1 = new System.Windows.Forms.NumericUpDown();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.numericUpDown2 = new System.Windows.Forms.NumericUpDown();
			this.numericUpDown4 = new System.Windows.Forms.NumericUpDown();
			this.button4 = new System.Windows.Forms.Button();
			this.checkBox5 = new System.Windows.Forms.CheckBox();
			this.label2 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.numericUpDown3 = new System.Windows.Forms.NumericUpDown();
			this.colorDialog1 = new System.Windows.Forms.ColorDialog();
			this.label5 = new System.Windows.Forms.Label();
			this.button3 = new System.Windows.Forms.Button();
			this.colorDialog2 = new System.Windows.Forms.ColorDialog();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown1)).BeginInit();
			this.groupBox3.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown4)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown3)).BeginInit();
			this.groupBox4.SuspendLayout();
			this.SuspendLayout();
			// 
			// checkBox1
			// 
			this.checkBox1.Location = new System.Drawing.Point(16, 24);
			this.checkBox1.Name = "checkBox1";
			this.checkBox1.Size = new System.Drawing.Size(80, 24);
			this.checkBox1.TabIndex = 0;
			this.checkBox1.Text = "x grid";
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(24, 248);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(56, 23);
			this.button1.TabIndex = 1;
			this.button1.Text = "OK";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.button2.Location = new System.Drawing.Point(88, 248);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(56, 23);
			this.button2.TabIndex = 2;
			this.button2.Text = "Storno";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.checkBox1);
			this.groupBox1.Controls.Add(this.checkBox2);
			this.groupBox1.Location = new System.Drawing.Point(16, 16);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(136, 88);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Show grid";
			// 
			// checkBox2
			// 
			this.checkBox2.Location = new System.Drawing.Point(16, 56);
			this.checkBox2.Name = "checkBox2";
			this.checkBox2.Size = new System.Drawing.Size(80, 24);
			this.checkBox2.TabIndex = 0;
			this.checkBox2.Text = "y grid";
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.checkBox4);
			this.groupBox2.Controls.Add(this.checkBox3);
			this.groupBox2.Location = new System.Drawing.Point(16, 112);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(136, 80);
			this.groupBox2.TabIndex = 4;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Show legends of axes";
			// 
			// checkBox4
			// 
			this.checkBox4.Location = new System.Drawing.Point(16, 48);
			this.checkBox4.Name = "checkBox4";
			this.checkBox4.Size = new System.Drawing.Size(96, 24);
			this.checkBox4.TabIndex = 0;
			this.checkBox4.Text = "y-axes";
			// 
			// checkBox3
			// 
			this.checkBox3.Location = new System.Drawing.Point(16, 16);
			this.checkBox3.Name = "checkBox3";
			this.checkBox3.Size = new System.Drawing.Size(96, 24);
			this.checkBox3.TabIndex = 0;
			this.checkBox3.Text = "x-axes";
			// 
			// numericUpDown1
			// 
			this.numericUpDown1.Location = new System.Drawing.Point(80, 216);
			this.numericUpDown1.Minimum = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.numericUpDown1.Name = "numericUpDown1";
			this.numericUpDown1.Size = new System.Drawing.Size(48, 20);
			this.numericUpDown1.TabIndex = 5;
			this.numericUpDown1.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.numericUpDown1.Value = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(24, 200);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(112, 32);
			this.label1.TabIndex = 6;
			this.label1.Text = "Number of segments on y-axes:";
			// 
			// groupBox3
			// 
			this.groupBox3.Controls.Add(this.numericUpDown2);
			this.groupBox3.Controls.Add(this.numericUpDown4);
			this.groupBox3.Controls.Add(this.button4);
			this.groupBox3.Controls.Add(this.checkBox5);
			this.groupBox3.Controls.Add(this.label2);
			this.groupBox3.Controls.Add(this.label4);
			this.groupBox3.Controls.Add(this.label6);
			this.groupBox3.Location = new System.Drawing.Point(160, 120);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(168, 160);
			this.groupBox3.TabIndex = 7;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "Graph marks";
			// 
			// numericUpDown2
			// 
			this.numericUpDown2.Location = new System.Drawing.Point(104, 56);
			this.numericUpDown2.Minimum = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.numericUpDown2.Name = "numericUpDown2";
			this.numericUpDown2.Size = new System.Drawing.Size(48, 20);
			this.numericUpDown2.TabIndex = 1;
			this.numericUpDown2.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.numericUpDown2.Value = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			// 
			// numericUpDown4
			// 
			this.numericUpDown4.Location = new System.Drawing.Point(104, 88);
			this.numericUpDown4.Minimum = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.numericUpDown4.Name = "numericUpDown4";
			this.numericUpDown4.Size = new System.Drawing.Size(48, 20);
			this.numericUpDown4.TabIndex = 1;
			this.numericUpDown4.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.numericUpDown4.Value = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			// 
			// button4
			// 
			this.button4.BackColor = System.Drawing.SystemColors.Control;
			this.button4.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.button4.Location = new System.Drawing.Point(104, 120);
			this.button4.Name = "button4";
			this.button4.Size = new System.Drawing.Size(48, 24);
			this.button4.TabIndex = 10;
			this.button4.Click += new System.EventHandler(this.button4_Click);
			// 
			// checkBox5
			// 
			this.checkBox5.Location = new System.Drawing.Point(24, 24);
			this.checkBox5.Name = "checkBox5";
			this.checkBox5.Size = new System.Drawing.Size(96, 24);
			this.checkBox5.TabIndex = 0;
			this.checkBox5.Text = "show marks";
			this.checkBox5.CheckedChanged += new System.EventHandler(this.checkBox5_CheckedChanged);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(88, 23);
			this.label2.TabIndex = 6;
			this.label2.Text = "Size of marks:";
			// 
			// label4
			// 
			this.label4.Location = new System.Drawing.Point(16, 88);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(88, 23);
			this.label4.TabIndex = 6;
			this.label4.Text = "Marks line width:";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(16, 120);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(88, 24);
			this.label6.TabIndex = 9;
			this.label6.Text = "Marks line color";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 24);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(96, 23);
			this.label3.TabIndex = 6;
			this.label3.Text = "Graph line width:";
			// 
			// numericUpDown3
			// 
			this.numericUpDown3.Location = new System.Drawing.Point(104, 24);
			this.numericUpDown3.Minimum = new System.Decimal(new int[] {
																		   1,
																		   0,
																		   0,
																		   0});
			this.numericUpDown3.Name = "numericUpDown3";
			this.numericUpDown3.Size = new System.Drawing.Size(48, 20);
			this.numericUpDown3.TabIndex = 1;
			this.numericUpDown3.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
			this.numericUpDown3.Value = new System.Decimal(new int[] {
																		 1,
																		 0,
																		 0,
																		 0});
			// 
			// label5
			// 
			this.label5.Location = new System.Drawing.Point(16, 56);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(104, 24);
			this.label5.TabIndex = 9;
			this.label5.Text = "Graph line color";
			// 
			// button3
			// 
			this.button3.FlatStyle = System.Windows.Forms.FlatStyle.Flat;
			this.button3.Location = new System.Drawing.Point(104, 56);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(48, 24);
			this.button3.TabIndex = 10;
			this.button3.Click += new System.EventHandler(this.button3_Click_1);
			// 
			// groupBox4
			// 
			this.groupBox4.Controls.Add(this.numericUpDown3);
			this.groupBox4.Controls.Add(this.button3);
			this.groupBox4.Controls.Add(this.label3);
			this.groupBox4.Controls.Add(this.label5);
			this.groupBox4.Location = new System.Drawing.Point(160, 16);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(168, 96);
			this.groupBox4.TabIndex = 11;
			this.groupBox4.TabStop = false;
			this.groupBox4.Text = "Graph line";
			// 
			// VectorRendererSettings
			// 
			this.AcceptButton = this.button1;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.button2;
			this.ClientSize = new System.Drawing.Size(346, 296);
			this.Controls.Add(this.groupBox4);
			this.Controls.Add(this.groupBox3);
			this.Controls.Add(this.numericUpDown1);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.button2);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.label1);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "VectorRendererSettings";
			this.Text = "Vector Graph Settings";
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown1)).EndInit();
			this.groupBox3.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown4)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.numericUpDown3)).EndInit();
			this.groupBox4.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Save settings (button OK click).
		/// </summary>
		/// <param name="sender">Sender.</param>
		/// <param name="e">Event parameters.</param>
		private void button1_Click(object sender, System.EventArgs e)
		{
			this.rendererPanel.showXGrid = this.checkBox1.Checked;
			this.rendererPanel.showYGrid = this.checkBox2.Checked;
			this.rendererPanel.showXAxesLegend = this.checkBox3.Checked;
			this.rendererPanel.showYAxesLegend = this.checkBox4.Checked;
			this.rendererPanel.y_segment_count = (int) this.numericUpDown1.Value;
			this.rendererPanel.showGraphMarks = this.checkBox5.Checked;
			this.rendererPanel.graph_mark_size = (int) this.numericUpDown2.Value;
			this.rendererPanel.graphLineWidth = (int) this.numericUpDown3.Value;
			this.rendererPanel.graphMarkLineWidth = (int) this.numericUpDown4.Value;
			this.rendererPanel.graphLineColor = this.colorDialog1.Color;
			this.rendererPanel.marksLineColor = this.colorDialog2.Color;

			this.Close();
			this.rendererPanel.Refresh();
		} // button1_Click()

		/// <summary>
		/// Button Storno click.
		/// </summary>
		/// <param name="sender">Sender.</param>
		/// <param name="e">Event parameters.</param>
		private void button2_Click(object sender, System.EventArgs e)
		{
			this.Close();
		} // button2_Click()

		/// <summary>
		/// Changed the state of checkbox for marker size.
		/// </summary>
		/// <param name="sender">Sender.</param>
		/// <param name="e">Event parameters.</param>
		private void checkBox5_CheckedChanged(object sender, System.EventArgs e)
		{
			this.numericUpDown2.Enabled = this.checkBox5.Checked;
			this.numericUpDown4.Enabled = this.checkBox5.Checked;
			this.button4.Enabled = this.checkBox5.Checked;
			this.label2.Enabled = this.checkBox5.Checked;
			this.label4.Enabled = this.checkBox5.Checked;
			this.label6.Enabled = this.checkBox5.Checked;
		} // checkBox5_CheckedChanged()

		/// <summary>
		/// Change the color of graph.
		/// </summary>
		/// <param name="sender">Sender.</param>
		/// <param name="e">Event parameters.</param>
		private void button3_Click_1(object sender, System.EventArgs e)
		{
			this.colorDialog1.ShowDialog(this);
			this.button3.BackColor = this.colorDialog1.Color;
		} // button3_Click_1()

		/// <summary>
		/// Change the color of markers.
		/// </summary>
		/// <param name="sender">Sender.</param>
		/// <param name="e">Event parameters.</param>
		private void button4_Click(object sender, System.EventArgs e)
		{
			this.colorDialog2.ShowDialog(this);
			this.button4.BackColor = this.colorDialog2.Color;
		} // button4_Click()

	} // class VectorRendererSettings
} // namespace
