using System;
using Zcu.Mve.Numerics;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Module for vector rendering.
	/// </summary>
	[ModuleInfo("Miroslav Vavruka", 
		 "Module for vector rendering.", 
		 Assemblied = "2004-09-4", 
		 IconName="VectorRenderer.ico")]
	[PortInfo("Input", "Vector for rendering.")]
	public class VectorRenderer : Zcu.Mve.Core.Module
	{
		/// <summary>
		/// Panel for vector rendering.
		/// </summary>
		private VectorRendererPanel panel;
		private IVector data;

		/// <summary>
		/// Creates ports.
		/// </summary>
		public VectorRenderer()
		{
			this.AddInPort("Input", typeof (IVector));
		} // VectorRenderer()

		/// <summary>
		/// Executes the VectorRenderer functionality.
		/// </summary>
		public override void Execute()
		{
			data = (IVector) this.GetInput("Input");      
			System.Threading.Thread regGridRen = new System.Threading.Thread(new System.Threading.ThreadStart(this.RunRenderer));
			regGridRen.Start();
		} // Execute()

		/// <summary>
		/// Show the Renderer panel and render the vector.
		/// </summary>
		public void RunRenderer()
		{
			panel = new VectorRendererPanel(data);
			panel.ShowDialog();
		}

	} // class VectorRenderer
} // namespace
