using System;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Module computes the absolute value of vector.
	/// </summary>
	[ModuleInfo("Milan Frank", "Module computes the absolute value of vector.")]
	[PortInfo("vector", "vector")]
	[PortInfo("scalar", "absolute value of vector")]
	public class VectorNorm : Zcu.Mve.Core.Module
	{
		Scalar s = new Scalar();

		/// <summary>
		/// Creates ports.
		/// </summary>
		public VectorNorm()
		{
			AddInPort("vector", typeof(Vector2D));
			AddOutPort("scalar", typeof(Scalar));
		}

		/// <summary>
		/// Method executes the VectorNorm functionality.
		/// </summary>
		public override void Execute()
		{
			Vector2D v = (Vector2D) GetInput("vector");
			s.Value = Math.Sqrt(v.X*v.X + v.Y*v.Y);      
			SetOutput("scalar", s);
		}
	}
}
