using System;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Interface that represents a vector.
	/// </summary>
	public interface IVector : IDataObject
	{
		/// <summary>
		/// Get number of elements of vector.
		/// </summary>
		int Length
		{
			get;
		}

		/// <summary>
		/// Get/Set element of vector.
		/// </summary>
		double this [int index]
		{
			get;
			set;
		}

		/// <summary>
		/// Absolute value of vector
		/// </summary>
		/// <returns></returns>
		double Abs();

	} // abstract class Vector
} // namespace