using System;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Module performs the summation of two scalar values.
	/// </summary>	
	[ModuleInfo("Milan Frank", "Performs the summation of two scalar values: c = a + b.")]
	[PortInfo("a", "first operator")]
	[PortInfo("b", "second operator")]
	[PortInfo("c", "result")]
	public class Summation : Zcu.Mve.Core.Module
	{
		Scalar c;
    
		/// <summary>
		/// Creates ports.
		/// </summary>
		public Summation()
		{
			AddInPort("a", typeof(Scalar));
			AddInPort("b", typeof(Scalar));
			AddOutPort("c", typeof(Scalar));
		}
	
		/// <summary>
		/// Method executes the summation.
		/// </summary>
		public override void Execute()
		{
			Scalar a = (Scalar) GetInput("a");
			Scalar b = (Scalar) GetInput("b");

			c.Value = a.Value + b.Value;
      
			SetOutput("c", c);
		}
	}
}
