using System;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Module performs the subraction of two scalar values.
	/// </summary>	
	[ModuleInfo("Milan Frank", "Performs the subraction of two scalar values: c = a - b")]
	[PortInfo("a", "first operator")]
	[PortInfo("b", "second operator")]
	[PortInfo("c", "result")]
	public class Subtraction : Zcu.Mve.Core.Module
	{
		Scalar c = new Scalar();
    
		/// <summary>
		/// Creates ports.
		/// </summary>
		public Subtraction()
		{
			AddInPort("a", typeof(Scalar));
			AddInPort("b", typeof(Scalar));
			AddOutPort("c", typeof(Scalar));
		}
	
		/// <summary>
		/// Method executes the subtraction.
		/// </summary>
		public override void Execute()
		{
			Scalar a = (Scalar) GetInput("a");
			Scalar b = (Scalar) GetInput("b");

			c.Value = a.Value - b.Value;

			SetOutput("c", c);
		}
	}
}

