using System;
using System.Drawing;
using System.Windows.Forms;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Graphical setup for ScalarSource module.
	/// </summary>
	public class NumberSourceSetup : Zcu.Mve.Core.ModuleSetup
	{
		//---------------------------------------- ATTRIBUTE --------------------------------------------------//

		#region Attributes component - designer generated code

		private CheckBox checkBox;
		private Label label;
		#endregion
		private System.Windows.Forms.TextBox textBox1;

		/// <summary>Asociation with the module.</summary>
		private ScalarSource scalarSource;

		//---------------------------------------- CONSTRUCTOR --------------------------------------------------//
	
		/// <summary>
		/// Inicialization of GUI.
		/// </summary>
		/// <param name="scalarSource">ScalarSource module.</param>
		public NumberSourceSetup(ScalarSource scalarSource)
		{
			this.InitializeComponent();

			this.scalarSource = scalarSource;
			this.checkBox.Checked = (scalarSource.random != null);
			this.textBox1.Text = scalarSource.number.ToString(Globals.nfi);
		}

		#region Inicialize component - designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label = new System.Windows.Forms.Label();
			this.checkBox = new System.Windows.Forms.CheckBox();
			this.textBox1 = new System.Windows.Forms.TextBox();
			this.SuspendLayout();
			// 
			// label
			// 
			this.label.Location = new System.Drawing.Point(4, 28);
			this.label.Name = "label";
			this.label.Size = new System.Drawing.Size(112, 16);
			this.label.TabIndex = 1;
			this.label.Text = "Value";
			// 
			// checkBox
			// 
			this.checkBox.Location = new System.Drawing.Point(4, 4);
			this.checkBox.Name = "checkBox";
			this.checkBox.Size = new System.Drawing.Size(112, 16);
			this.checkBox.TabIndex = 2;
			this.checkBox.Text = "Random";
			this.checkBox.CheckedChanged += new System.EventHandler(this.checkBox_CheckedChanged);
			// 
			// textBox1
			// 
			this.textBox1.Location = new System.Drawing.Point(8, 44);
			this.textBox1.Name = "textBox1";
			this.textBox1.TabIndex = 3;
			this.textBox1.Text = "textBox1";
			// 
			// NumberSourceSetup
			// 
			this.Controls.Add(this.textBox1);
			this.Controls.Add(this.checkBox);
			this.Controls.Add(this.label);
			this.Name = "NumberSourceSetup";
			this.Size = new System.Drawing.Size(120, 68);
			this.ResumeLayout(false);

		}
		#endregion

		//---------------------------------------- EVENT --------------------------------------------------//

		// zce 3.9.2004 - pidna nvratov hodnota potvrzovac metody
		/// <summary>
		/// Method for saving of settins.
		/// </summary>
		public override bool OnOkClick()
		{
			if (this.checkBox.Checked)
				this.scalarSource.random = new Random();
			else
				this.scalarSource.random = null;
			this.scalarSource.number = Double.Parse(this.textBox1.Text, Globals.nfi);

			return true;
		}

		/// <summary>
		/// Reaction for checkBox state change.
		/// </summary>
		/// <param name="sender">Sender.</param>
		/// <param name="evn">Event arguments.</param>
		private void checkBox_CheckedChanged(object sender, EventArgs evn)
		{
			this.textBox1.Enabled = !this.checkBox.Checked;
		}
	}
}

