using System;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	//pdv - 20040603 14:03 - pridan atribut
	//pdv - 20040620 16:27 - pridany atributy PortInfo

	/// <summary>
	/// Test module, source of one scalar number (random or given).
	/// </summary>
	[ModuleInfo("Milan Frank", "Source of one scalar number.",
		 IconName = "numbersource.ico", Assemblied = "2004-06-13")]
	[PortInfo("output", "scala number")]
	public class ScalarSource : Zcu.Mve.Core.Module
	{
		// zce 26.6.2004 - zmna prva na internal
		internal double number;
		// zce 26.6.2004 - zmna prva na internal
		internal Random random = new Random();
		Scalar output = new Scalar(0.0);

		/// <summary>
		/// Creates ports.
		/// </summary>
		public ScalarSource()
		{
			AddOutPort("output", typeof (Scalar));
		}
	
		/// <summary>
		/// Method executes the scalar source functionality.
		/// </summary>
		public override void Execute()
		{
			if (random != null)
				output.Value = random.NextDouble();
			else
				output.Value = number;
    
			SetOutput("output", output);
		}
	
		/// <summary>
		/// Write the configuration data in XML file.
		/// </summary>
		/// <param name="config">XmlElement containing the configuration data.</param>
		public override void WriteConfig(System.Xml.XmlElement config)
		{
			if (random != null)
				config.InnerText = "random";
			else
				config.InnerText = number.ToString(Globals.nfi);
		}

		/// <summary>
		/// Read the configuration data from XML file.
		/// </summary>
		/// <param name="config">XmlElement containing the configuration data.</param>
		public override void ReadConfig(System.Xml.XmlElement config)
		{
			if (String.Compare(config.InnerText, "random", true) == 0)
			{
				random = new Random();
			}
			else
			{
				random = null;
				number = Double.Parse(config.InnerText, Globals.nfi);
			}
		}

		/// <summary>
		/// Invoke module setup.
		/// </summary>
		/// <returns>Module setup.</returns>
		public override ModuleSetup InvokeSetup()
		{
			return new NumberSourceSetup(this);
		}
	
		// ZCE 13.4.2005 - deep copy bug fixed
		/// <summary>
		/// Create deep copy of module (the same data, , different memory space).
		/// </summary>
		/// <returns>The deep copy of module (the same data, , different memory space).</returns>
		public override Module DeepCopy()
		{
			ScalarSource module = (ScalarSource) base.DeepCopy ();
			module.number = this.number;
			if (this.random != null)
				module.random = new Random();
			else
				module.random = null;

			return module;
		}
	}		
}
