using System;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Module performs the multiplication of 2D vector by scalar value: result = vector * scalar.
	/// </summary>	
	[ModuleInfo("Milan Frank", "Performs the multiplication of 2D vector by scalar value: result = vector * scalar.")]
	[PortInfo("scalar", "scalar value")]
	[PortInfo("vector", "vektor")]
	[PortInfo("result", "result")]
	public class Multiplication : Zcu.Mve.Core.Module
	{
		Vector2D result = new Vector2D();
    
		/// <summary>
		/// Creates ports.
		/// </summary>
		public Multiplication()
		{
			AddInPort("scalar", typeof(Scalar));
			AddInPort("vector", typeof(Vector2D));
			AddOutPort("result", typeof(Vector2D));
		}
		
		/// <summary>
		/// Method executes the multiplication.
		/// </summary>
		public override void Execute()
		{
			Scalar s = (Scalar) GetInput("scalar");
			Vector2D v = (Vector2D) GetInput("vector");

			result.X = v.X * s.Value;
			result.Y = v.Y * s.Value;

			SetOutput("result", result);
		}
	}
}
