using System;
using Zcu.Mve.Core;

namespace Zcu.Mve.Numerics
{
	/// <summary>
	/// Module performs the division of two scalar values.
	/// </summary>
	[ModuleInfo("Milan Frank", "Performs the division of two scalar values: c = a / b.")]
	[PortInfo("a", "dividend")]
	[PortInfo("b", "divider")]
	[PortInfo("c", "result")]
	public class Division : Zcu.Mve.Core.Module
	{
		Scalar c = new Scalar();
    
		/// <summary>
		/// Creates ports.
		/// </summary>
		public Division()
		{
			AddInPort("a", typeof(Scalar));
			AddInPort("b", typeof(Scalar));
			AddOutPort("c", typeof(Scalar));		
		}
	
		/// <summary>
		/// Method executes the divison.
		/// </summary>
		public override void Execute()
		{
			Scalar a = (Scalar) GetInput("a");
			Scalar b = (Scalar) GetInput("b");
      
			c.Value = a.Value / b.Value;

			SetOutput("c", c);
		}
	}
}
